/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.bpcrcon;

import com.ibm.hwmca.base.bpcrcon.BackupErrorIds;
import com.ibm.hwmca.base.bpcrcon.BackupExcludeData;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.managed.ClassId;
import com.ibm.hwmca.fw.managed.HwmcaObject;
import com.ibm.hwmca.fw.managed.ManagedObjectManager;
import com.ibm.hwmca.fw.managed.Tower;
import com.ibm.hwmca.fw.util.Trace;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

class BackupExcludeUtil
implements BackupErrorIds {
    private static final String TRACE_MASKT = "XBKPUTLT";
    private static final String TRACE_MASKF = "XBKPUTLF";
    private static final String TRACE_MASKD = "XBKPUTLD";
    private static final String INTERFACE_NAME = "com.ibm.hwmca.base.bpcrcon.BackupExcludeData";
    private static final String PACKAGE_NAME = "com.ibm.hwmca.fw.managed";
    private static final String CLASS_NAME = "Tower";
    private static FrameworkClassLogInfo _logInfo = new FrameworkClassLogInfo(85, "BackupUtil");
    private List implList = new ArrayList();
    private List excludeFilesList = null;
    private int numItems;
    String[] excludedFiles;

    BackupExcludeUtil() {
        ClassId classId = new ClassId(PACKAGE_NAME, CLASS_NAME);
        Set inventory = ManagedObjectManager.getManagedObjectManager().getInventory(classId);
        Trace.trace(TRACE_MASKT, "tower inventory size: " + inventory.size());
        Iterator iterator = inventory.iterator();
        while (iterator.hasNext()) {
            HwmcaObject obj = (HwmcaObject)iterator.next();
            try {
                Object impl = ((Tower)obj).getInterfaceImpl(Class.forName(INTERFACE_NAME));
                if (impl == null) continue;
                Trace.trace(TRACE_MASKT, "adding an impl");
                this.implList.add(impl);
            }
            catch (Exception e) {}
        }
        this.excludeFilesList = new ArrayList();
        ArrayList<BackupExcludeData> badImpls = new ArrayList<BackupExcludeData>();
        this.numItems = 0;
        Iterator iterator2 = this.implList.iterator();
        while (iterator2.hasNext()) {
            BackupExcludeData implClass = (BackupExcludeData)iterator2.next();
            String[] items = implClass.getExcludedFiles();
            if (items.length == 0) {
                Trace.trace(TRACE_MASKT, "Bad impl! Bad impl!");
                badImpls.add(implClass);
                continue;
            }
            this.excludeFilesList.add(items);
            this.numItems += items.length;
        }
        if (this.numItems != 0) {
            this.excludedFiles = new String[this.numItems];
            int runningTotal = 0;
            for (int i = 0; i < this.excludeFilesList.size(); ++i) {
                String[] itemArray = (String[])this.excludeFilesList.get(i);
                for (int j = 0; j < itemArray.length; ++j) {
                    this.excludedFiles[runningTotal] = itemArray[j];
                    ++runningTotal;
                }
            }
        } else {
            this.excludedFiles = null;
        }
        Trace.trace(TRACE_MASKT, "We will have " + this.numItems + " entries in the list");
    }

    String[] getExcludedFilesList() {
        return this.excludedFiles;
    }
}

